<?php
include 'db.php'; // Include your database connection file

header("Content-Type: application/json");

// Check if the request method is GET
if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    echo json_encode(["status" => "error", "message" => "Invalid request method"]);
    exit;
}

// Fetch wishlist data grouped by customer_id, including customer name and phone number
$query = "SELECT w.customer_id, c.displayname AS customer_name, c.phoneno AS phone, w.product_id, w.product_name 
          FROM wish_list w
          LEFT JOIN customer c ON c.id = w.customer_id
          ORDER BY w.customer_id";

$result = mysqli_query($conn, $query);

// Initialize an empty array for grouped results
$grouped_wishlist = [];

if (mysqli_num_rows($result) > 0) {
    while ($row = mysqli_fetch_assoc($result)) {
        $customer_id = $row['customer_id'];

        // If customer_id is not in the grouped array, initialize it
        if (!isset($grouped_wishlist[$customer_id])) {
            $grouped_wishlist[$customer_id] = [
                "customer_id" => $row['customer_id'],
                "customer_name" => $row['customer_name'],
                "phone" => $row['phone'],
                "product_count" => 0,
                "wishlist_count" => 0,
                "products" => [] // Store product details in an array
            ];
        }

        // Add product_id and product_name to the array
        $grouped_wishlist[$customer_id]["products"][] = [
            "product_id" => $row['product_id'],
            "product_name" => $row['product_name']
        ];

        // Update counts
        $grouped_wishlist[$customer_id]["product_count"] = count(array_unique(array_column($grouped_wishlist[$customer_id]["products"], "product_id")));
        $grouped_wishlist[$customer_id]["wishlist_count"]++;
    }

    // Convert grouped results to a simple array
    $output = array_values($grouped_wishlist);

    echo json_encode(["status" => "success", "data" => $output]);
} else {
    echo json_encode(["status" => "error", "message" => "No records found"]);
}
?>
